import bib, misc
import sys,string,socket,os,re
import pygtk, gtk.glade, gobject
import gnome


def sort_col(col, colid):
    settings = misc.GetSingletonSetting()
    currid,sorttype = settings.treemodel.get_sort_column_id()

    if currid == colid:
        settings.treemodel.set_sort_column_id(colid, not sorttype)
    else:
        settings.treemodel.set_sort_column_id(colid, gtk.SORT_ASCENDING)
        

def DisplayBibEntries(bibdict):

    settings = misc.GetSingletonSetting()

    # get the TreeView and make a ListStore
    tv = settings.widgets['bibtreeview']
    settings.treemodel = gtk.ListStore(
            gobject.TYPE_STRING, 
            gobject.TYPE_STRING,
            gobject.TYPE_STRING,
            gobject.TYPE_STRING )

    # Load the contents
    c = 0
    for key in bibdict.keys():
        c += 1
        author = bibdict[key].get_first_author()
        year = bibdict[key].get_year()
        title = bibdict[key].get_title()
        

        liter = settings.treemodel.append()
        settings.treemodel.set(liter,
                misc.COL_KEY, key,
                misc.COL_AUTHOR, author,
                misc.COL_YEAR, year,
                misc.COL_TITLE, title)

    settings.widgets['toplevelstatusbar'].push(0,'%d references' % (c))
        
    # allow for sorting
    settings.treemodel.set_sort_column_id(misc.COL_AUTHOR, gtk.SORT_ASCENDING)
    

    # set some details for the TreeView
    tv.set_headers_visible(gtk.TRUE)
    tv.set_model(settings.treemodel)

    # Set up the column headers
    renderer = gtk.CellRendererText()
        
    # zeroth column
    column=gtk.TreeViewColumn("key",renderer, text=misc.COL_KEY)
    column.set_resizable(gtk.TRUE)
    column.set_visible(gtk.FALSE)
    tv.append_column(column)
    
    # first column
    column=gtk.TreeViewColumn("Author",renderer, text=misc.COL_AUTHOR)
    column.set_resizable(gtk.TRUE)
    column.connect('clicked', sort_col, misc.COL_AUTHOR)
    tv.append_column(column)
    
    
    # second column
    column=gtk.TreeViewColumn("Year",renderer, text=misc.COL_YEAR)
    column.set_resizable(gtk.TRUE)
    column.connect('clicked', sort_col, misc.COL_YEAR)
    tv.append_column(column)
    
    # third column
    column=gtk.TreeViewColumn("Title",renderer, text=misc.COL_TITLE)
    column.set_resizable(gtk.TRUE)
    column.connect('clicked', sort_col, misc.COL_TITLE)
    tv.append_column(column)
    
    # allow for multiple selections
    sel = tv.get_selection()
    sel.set_mode(gtk.SELECTION_MULTIPLE)
    
    # now that columns are set allow for clicks
    tv.set_headers_clickable(gtk.TRUE)
    tv.show()

