#!/usr/bin/python

from handlers import *
import bib, misc, tv
import sys,string,socket,os,re
import pygtk, gtk.glade, gobject
import gnome


def process_socket_message(source, condition):

    # see what type of message we got
    conn = source.accept()[0]
    got = conn.recv(20)
    if string.find(got,'/currcite/') != 0:
        print 'bibpysocket:: %s: invalid message string' % (got)
        return gtk.TRUE
    
    # get the keys for selected citations
    def f(store,data,titer,set):
        if not titer: return
        else:
            key = store.get_value(titer,0)
            if key in set.currcite.keys():
                del set.currcite[key]
            else: set.currcite[key] = ''
            
    settings = misc.GetSingletonSetting()
    tv = settings.widgets['bibtreeview']
    sel = tv.get_selection()
    sel.selected_foreach(f,settings)

    # format the string with the firt 4 characters being
    # a zero padded length of the citation string and then the citation
    # keys, seperated by /
    msg = string.join(settings.currcite,'/')
    msglen = re.sub('\s','0', '%5d' % len(msg))
    msg = msglen+msg
    conn.send(msg)

    # once the cite keys have been sent clear out the curr cite dict
    settings.currcite = {}
    return gtk.TRUE


if __name__ == '__main__':
    global widgets
    global guifile 
    
    gnome.init('xxx','xxx')
    widgets = misc.WidgetsWrapper('gui.glade','toplevel', TopLevelHandlers)
    
    settings = misc.GetSingletonSetting()
    settings.guifile = 'gui.glade'
    settings.widgets = widgets
    settings.currcite = {}

    # set up the socket to get messages from a client
    sockpath = os.path.join(os.environ['HOME'],'.pybibsocket')
    sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
    sock.bind(sockpath)
    sock.listen(1)

    # setup and input_add
    socket_handler_id = gtk.input_add_full(sock, gtk.gdk.INPUT_READ, process_socket_message)
    settings.sockid = socket_handler_id
    settings.sockname = sockpath
    
    if len(sys.argv) == 2:
        # load the supplied bib file
        bibdict = bib.LoadBibFile(sys.argv[1])
        settings.bibdict = bibdict
        tv.DisplayBibEntries(bibdict)
        
    gtk.mainloop ()
